//
//  MCModelList.h
//  MCApplication
//
//  Created by aj on Mon Oct 01 2001.
//  Copyright (c) 2001 __CompanyName__. All rights reserved.
//

#import <AppKit/AppKit.h>
#import "MCWindowController.h"

@class MCBinder, MCBinding, MCAMD, MCTableviewController, MCChannel;

@interface MCModelList : MCWindowController {

	id 										(model);
	id										(contentView);
	id										(printController);
	id 										(dataForPasteboard);
	
	IBOutlet		MCChannel				*channel;
	IBOutlet		MCAMD					*amd;
	IBOutlet		MCTableviewController	*tvc;
	
    IBOutlet 		NSView 					*lastKeyView;
	
	
	BOOL			_awoke;
	BOOL			_independantModelFromParent;

}

- (void)prepareForDealloc;

// In order to facilitate dragging from one list to another, we store the values of dragged rows here so that the destination can easily get them. We avoid the pasteboard because it's difficult to archive the object id's to pass them along -- also why go through the extra step of archiving when we can just move pointers around
- (void)setDataForPasteboard:(id)aData;
- (id)dataForPasteboard;

- (BOOL)isActingAsSubEditor;

// When a model editor is acting as a sub editor, it can have a different model than that of the parent. The default behaviour is to pass the model, but that can be prevented by calling subEditorWithName: passCurrentModel: or switchSwitchViewToSubEditorWithName: passCurrentModel: with NO as an argument. When setModel or setModelNoUpdate is called on the parent controller, the sub editor is called using the takeModelFromParent and if the usesIndependantModelFromParent is set, the model is not set on the sub editor.
- (void)setUsesIndependantModelFromParent:(BOOL)flag;
- (BOOL)usesIndependantModelFromParent;
- (void)takeModelFromParent:(id)aModel;

// if sub editor, asks the parent controller is locked
- (BOOL)isMutable;

// tells the amd and LOCK channel to enable or disable
- (void)passMutabilityFlag:(BOOL)flag;

- (NSView *)initialFirstResponder;

- (NSView *)lastKeyView;

- (void)finalizeModelUsage;

- (void)becomeCurrentEditor;
- (void)resignCurrentEditor;


- (MCAMD *)amd;
- (MCTableviewController *)tvc;

- (void)setModel:aModel;
- (void)setModelNoUpdate:aModel;
- (id)model;

- (NSArray *)selectedObjects;

- (void)updateModelFromInterface;
- (void)updateInterfaceFromModel;

- (id)contentView;

// subclassers can override -- default does simple (sometimes expensive) re-display in 'did' notif, 'will' does nothing

- (void)modelDidChangeNotification:(NSNotification *)notif;

- (void)modelWillAddNotification:(NSNotification *)notif;
- (void)modelDidAddNotification:(NSNotification *)notif;

- (void)modelWillRemoveNotification:(NSNotification *)notif;
- (void)modelDidRemoveNotification:(NSNotification *)notif;


// does nothing -- subclassers should do their defaults dependant config in this method. When the user changes their defaults(preferences), this method is invoked
- (void)configureFromUserDefaultsNotification:(NSNotification *)notif;


// uses defaultTablePrintControl to dynamic print the table contents
//- (IBAction)print:(id)sender;
- (void)runPrintOperationWithPrintInfo:(NSPrintInfo *)pi showPanels:(BOOL)flag;


- (void)setPrintController:(id)aController;
- (id)printController;

// Gives subclassers the opportunity to provide config info
- (id)createPrintController;
- (id)preparePrintPageModel; // page title and such
- (id)preparePrintUserInfo; // replacement views and identifiers

// delegate should call super when monitoring this
- (void)bindingDidUpdate:(MCBinding *)aBinding;


@end
